package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;

public class SQDUGDocumentRuleEvaluator extends AbstractDocumentRuleEvaluator {
	
	/** Is a specific document required for a location?
	 * 
	 */
	@Override
	public boolean isRequired(final Request req, final DataSource ds, final DocumentTemplate temp, final Location site, final boolean isIndependentOnly) {
		
		if (isDartRequest(req) == false) {
			return false;
		}
		
		DartRequest dartRequest = (DartRequest)req;



		Location primarySite = req.getPrimaryLocation();
		if (primarySite != null) {
		
			// IRB Approval of Waiver of HIPAA is required for the primary site if the HIPAA waiver is true
			if (temp.getName().startsWith("IRB Approval of Waiver of HIPAA") && site.getId() == primarySite.getId() && dartRequest.isHipaaWaiver() == true) {
				return true;
			}
			
			// Sample Informed Consent is required for the primary site if the HIPAA patient consent is true
			if (temp.getName().startsWith("Sample Informed Consent") && site.getId() == primarySite.getId() && dartRequest.isHipaaConsent() == true) {
				return true;
			}



			// Research Study Institutional Review Board (IRB) Approval is required for the primary site
			if (temp.getName().startsWith("Research Study Institutional Review Board (IRB) Approval") && site.getId() == primarySite.getId()) {
				return true;
			}
			
			// Research and Development (RD) Committee Approval is required for the primary site
			if (temp.getName().startsWith("Research and Development (RD) Committee Approval") && site.getId() == primarySite.getId()) {
				return true;
			}


			// Research Request Memo is required for the primary site
			if (temp.getName().startsWith("Research Request Memo") && site.getId() == primarySite.getId()) {
				return true;
			}

			// Surgery Data Research Proposal is required for the primary site
			if (temp.getName().startsWith("Surgery Data Research Proposal") && site.getId() == primarySite.getId()) {
				return true;
			}

			// National Surgery Office (NSO) Data Use Agreement is required for the primary site
			if (temp.getName().startsWith("National Surgery Office (NSO) Data Use Agreement") && site.getId() == primarySite.getId()) {
				return true;
			}

			//VA Surgical Quality Improvement Program (VASQIP)
			// Surgery Variable Checklist(s) is required for the primary site
			if (temp.getName().startsWith("VASQIP Variable Checklist(s)") && site.getId() == primarySite.getId()) {
				return true;
			}
			
		}
		
		return false;
	}

	
	/** Is a specific document required for a participant?
	 * 
	 */
	@Override
	public boolean isRequired(final Request req, final DataSource ds, final DocumentTemplate temp, final Participant participant, final boolean isIndependentOnly) {
		return false;  // end method
	}
	
	
	@Override
	public boolean isRequired(Request req, DataSource ds, DocumentTemplate temp, Group admin, Location site, final boolean isIndependentOnly) {
		
		Location primarySite = req.getPrimaryLocation();
		if( primarySite != null ) {
			
			if (temp.getName().startsWith("National Surgery Office (NSO) Data Use Agreement") && primarySite.getId() == site.getId() && admin.getName().equals("DART Surgery Administrators")) {
				return true;
			}

			if (temp.getName().startsWith("Review Summary") && primarySite.getId() == site.getId() && admin.getName().equals("DART Surgery Administrators")) {
				return true;
			}
			
		}//end if
			
		return false;
	}

	
	/** Is a specific administrator document required for a participant?
	 */
	@Override
	public boolean isRequired(final Request req, final DataSource ds, final DocumentTemplate temp, final Group admin, final Participant participant, final boolean isIndependentOnly) {
		return false;
	}
	

}
